% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{somQuality}
\alias{somQuality}
\title{SOM quality measures}
\usage{
somQuality(som, traindat)
}
\arguments{
\item{som}{\code{kohonen} object, a SOM created by the \code{kohonen::som} function.}

\item{traindat}{matrix containing the training data.}
}
\value{
A \code{list} containing quality measures : quantization error, share
  of explained variance, topographic error and Kaski-Lagus error (see
  Details).
}
\description{
Computes several quality measures on a trained SOM (see Details).
}
\details{
Four measures of SOM quality are returned : 
\describe{
  \item{Quantization error:}{Average squared distance between the data points and the map's prototypes to which they are mapped. Lower is better.}
  \item{Percentage of explained variance:}{Similar to other clustering methods, the share of total variance that is explained by the clustering (equal to 1 minus the ratio of quantization error to total variance). Higher is better.}
  \item{Topographic error:}{Measures how well the topographic structure of the data is preserved on the map. It is computed as the share of observations for which the best-matching node is not a neighbor of the second-best matching node on the map. Lower is better: 0 indicates excellent topographic representation (all best and second-best matching nodes are neighbors), 1 is the maximum error (best and second-best nodes are never neighbors).}
  \item{Kaski-Lagus error:}{Combines aspects of the quantization and topographic error. It is the sum of the mean distance between points and their best-matching prototypes, and of the mean geodesic distance (pairwise prototype distances following the SOM grid) between the points and their second-best matching prototype.}
}
}
\references{
Kohonen T. (2001) \emph{Self-Organizing Maps}, 3rd edition,
  Springer Press, Berlin. <doi:10.1007/978-3-642-56927-2>

  Kaski, S. and Lagus, K. (1996) Comparing Self-Organizing Maps. In C. von
  der Malsburg, W. von Seelen, J. C. Vorbruggen, and B. Sendho (Eds.)
  \emph{Proceedings of ICANN96, International Conference on Articial Neural
  Networks , Lecture Notes in Computer Science} vol. 1112, pp. 809-814.
  Springer, Berlin. <doi:10.1007/3-540-61510-5_136>
}
