#' @rdname cors
#' @title CORS
#' @description Get/Put/Delete the cross origin resource sharing configuration information for a bucket.
#'
#' @template bucket
#' @template dots
#'
#' @return For \code{get_cors}: A list with cors configuration and rules. For \code{delete_cors}: \code{TRUE} if successful, \code{FALSE} otherwise.
#' @references
#' \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html}{API Documentation: PUT cors}
#' \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketCors.html}{API Documentation: GET cords}
#' \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html}{API Documentation: DELETE cors}
#' @export
get_cors <- function(bucket, ...){
    r <- s3HTTP(verb = "GET", 
                bucket = bucket,
                query = list(cors = ""),
                ...)
    return(r)
}

#' @rdname cors
#' @export
put_cors <- function(bucket, ...){
    r <- s3HTTP(verb = "PUT", 
                bucket = bucket,
                query = list(cors = ""),
                ...)
    structure(r, class = "s3_bucket")
}

#' @rdname cors
#' @export
delete_cors <- function(bucket, ...){
    r <- s3HTTP(verb = "DELETE", 
                bucket = bucket,
                query = list(cors = ""),
                parse_response = FALSE,
                ...)
    return(r)
}
