% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace.R
\name{service_principal_authentication}
\alias{service_principal_authentication}
\title{Manages authentication using a service principle instead of a user identity.}
\usage{
service_principal_authentication(
  tenant_id,
  service_principal_id,
  service_principal_password,
  cloud = "AzureCloud"
)
}
\arguments{
\item{tenant_id}{The string id of the active directory tenant that the service
identity belongs to.}

\item{service_principal_id}{The service principal ID string.}

\item{service_principal_password}{The service principal password/key string.}

\item{cloud}{The name of the target cloud. Can be one of "AzureCloud", "AzureChinaCloud", or
"AzureUSGovernment". If no cloud is specified, "AzureCloud" is used.}
}
\value{
\code{ServicePrincipalAuthentication} object
}
\description{
Service Principal authentication is suitable for automated workflows like for CI/CD scenarios.
This type of authentication decouples the authentication process from any specific user login, and
allows for managed access control.
}
\section{Examples}{

Service principal authentication involves creating an App Registration in
Azure Active Directory. First, you generate a client secret, and then you grant
your service principal role access to your machine learning workspace. Then,
you use the \code{ServicePrincipalAuthentication} object to manage your authentication flow.\preformatted{svc_pr_password <- Sys.getenv("AZUREML_PASSWORD")
svc_pr <- service_principal_authentication(tenant_id="my-tenant-id",
                                           service_principal_id="my-application-id",
                                           service_principal_password=svc_pr_password)

ws <- get_workspace("<your workspace name>",
                    "<your subscription ID>",
                    "<your resource group>",
                    auth = svc_pr)
}
}

\seealso{
\code{\link[=get_workspace]{get_workspace()}} \code{\link[=interactive_login_authentication]{interactive_login_authentication()}}
}
