% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baselinenowcast.R
\name{baselinenowcast}
\alias{baselinenowcast}
\title{Generate a nowcast}
\usage{
baselinenowcast(
  data,
  scale_factor = 3,
  prop_delay = 0.5,
  output_type = c("samples", "point"),
  draws = 1000,
  uncertainty_model = fit_by_horizon,
  uncertainty_sampler = sample_nb,
  ...
)
}
\arguments{
\item{data}{Data to be nowcasted}

\item{scale_factor}{Numeric value indicating the multiplicative factor on
the maximum delay to be used for estimation of delay and uncertainty.
Default is \code{3}.}

\item{prop_delay}{Numeric value <1 indicating what proportion of all
reference times in the reporting triangle to be used for delay
estimation. Default is \code{0.5}.}

\item{output_type}{Character string indicating whether the output should be
samples (\code{"samples"}) from the estimate with full uncertainty or whether to
return the point estimate (\code{"point"}). Default is \code{"samples"}. If
\code{"point"}estimates are specified, the minimum number of reference times
needed is the number needed for delay estimation, otherwise, if
\code{"samples"} are specified, at least 2 additional reference times are
required for uncertainty estimation.}

\item{draws}{Integer indicating the number of probabilistic draws to include
if \code{output_type} is \code{"samples"}. Default is 1000.}

\item{uncertainty_model}{Function that ingests a matrix of observations and a
matrix of predictions and returns a vector that can be used to
apply uncertainty using the same error model. Default is
\code{fit_by_horizon} with arguments of \code{obs} matrix of observations and
\code{pred} the matrix of predictions that fits each column (horizon)
to a negative binomial observation model by default. The user can
specify a different fitting model by replacing the
\code{fit_model} argument in \code{fit_by_horizon}.}

\item{uncertainty_sampler}{Function that ingests a vector or matrix of
predictions and a vector of uncertainty parameters and generates draws
from the observation model. Default is \code{sample_nb} which expects
arguments \code{pred} for the vector of predictions and uncertainty parameters
for the corresponding vector of uncertainty parameters, and draws from a
negative binomial for each element of the vector.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Data.frame of class \link{baselinenowcast_df}
}
\description{
This function ingests data to be nowcasted and generates a
a \link{baselinenowcast_df} which contains a probabilistic or point
estimate of the final case counts at each reference date in the \code{data}.
See \code{\link[=baselinenowcast.reporting_triangle]{baselinenowcast.reporting_triangle()}} for details on the
input requirements.
}
\examples{
# Generate a point nowcast from a reporting triangle
nowcast <- baselinenowcast(
  example_reporting_triangle,
  output_type = "point"
)
nowcast

# Generate probabilistic nowcast with samples
baselinenowcast(
  example_reporting_triangle,
  output_type = "samples",
  draws = 100
)
}
\seealso{
Main nowcasting interface functions
\code{\link{assert_baselinenowcast_df}()},
\code{\link{baselinenowcast.data.frame}()},
\code{\link{baselinenowcast.reporting_triangle}()},
\code{\link{baselinenowcast_df-class}},
\code{\link{new_baselinenowcast_df}()}
}
\concept{baselinenowcast_df}
