% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{aic}
\alias{aic}
\title{Computes posterior sample of the point wise AIC method from a \code{varstan} object}
\usage{
aic(x)
}
\arguments{
\item{x}{A \code{varstan} object of the time series fitted model.}
}
\value{
A numeric array  of size R, containing the posterior samples of the AICc
for a \code{varstan} object, where R is the number of iterations. If multiple chains are
fitted, then the array is of length M*R, where M is the number of chains
}
\description{
Convenience function for computing the point wise Akaike Information Criteria
method from a \code{varstan} object.
}
\examples{
\donttest{
 model = Sarima(birth,order = c(0,1,2),seasonal = c(1,1,1))
 fit1 = varstan(model,iter = 500,chains = 1)

 aic1 = aic(fit1)
 mean(aic1)
}

}
\author{
Asael Alonzo Matamoros
}
