% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification_summary_cv.R
\name{classification_summary_cv}
\alias{classification_summary_cv}
\title{Cross-Validated Posterior Classification Summaries}
\usage{
classification_summary_cv(model, data, group, k, cutoff = 0.5)
}
\arguments{
\item{model}{an rstanreg model object with binary y}

\item{data}{data frame including the variables in the model, both response y (0 or 1) and predictors x}

\item{group}{a character string representing the name of the factor grouping variable, ie. random effect (only used for hierarchical models)}

\item{k}{the number of folds to use for cross validation}

\item{cutoff}{probability cutoff to classify a new case as positive}
}
\value{
a list
}
\description{
Given a set of observed data including a binary response variable y 
and an rstanreg model of y, 
this function returns cross validated estimates of the model's posterior classification quality:
sensitivity, specificity, and overall accuracy.
For hierarchical models of class lmerMod, the folds are comprised by collections of groups, not individual observations.
}
\examples{
x <- rnorm(20)
z <- 3*x
prob <- 1/(1+exp(-z))
y <- rbinom(20, 1, prob)
example_data <- data.frame(x = x, y = y)
example_model <- rstanarm::stan_glm(y ~ x, data = example_data, family = binomial)
classification_summary_cv(model = example_model, data = example_data, k = 2, cutoff = 0.5)                   
}
