% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_seatemp}
\alias{predict_seatemp}
\title{Predict sea-surface temperature given d18O of foram calcite and seawater d18O.}
\usage{
predict_seatemp(d18oc, d18osw, prior_mean, prior_std, foram = NULL,
  seasonal_seatemp = FALSE, drawsfun = get_draws)
}
\arguments{
\item{d18oc}{Numeric or vector of observed foram calcite d18O (‰ VPDB).}

\item{d18osw}{Numeric or vector of observed seawater d18O (‰ VSMOW).}

\item{prior_mean}{Numeric indicating prior mean for sea-surface temperature (°C).}

\item{prior_std}{Numeric indicating prior standard deviation for sea-surface 
temperature (°C).}

\item{foram}{Optional. String or \code{NULL}. String indicating the foram 
species/subspecies to infer for hierarchical models. String must be one of 
"G. bulloides", "G. ruber", "T. sacculifer", "N. incompta", or 
"N. pachyderma". \code{NULL} indicates that a pooled model is desired.}

\item{seasonal_seatemp}{Optional boolean indicating whether to use the seasonal 
sea-surface temperature calibrations. Default is \code{FALSE}, i.e. using 
annual SST calibrations.}

\item{drawsfun}{Optional function used to get get model parameter draws. Must 
take arguments for "foram" and "seasonal_seatemp" and return a list with 
members "alpha", "beta", "tau". This is for debugging and testing.}
}
\value{
A \code{prediction} instance for inferred sea-surface temperature (°C).
}
\description{
Predict sea-surface temperature given d18O of foram calcite and seawater d18O.
}
\details{
Four calibration models are available: an "annual pooled" model, a 
"seasonal pooled" model, an "annual hierarchical" model, and a 
"seasonal hierarchical" model. This function uses magic to determine which 
"pooled annual" model is used. Which is the simplest case with potential use 
for Deep Time reconstructions of nonexant foram species. Giving a valid string 
for \code{foram} will use a hierarchical model, which has foram-specific 
variability in calibration model parameters. Passing \code{TRUE} for 
\code{seasonal_seatemp} will use a model trained on season sea-surface 
temperatures. See reference paper for further details.
}
\examples{
data(bassriver)

# Using the "pooled annual" calibration model:
sst <- predict_seatemp(bassriver$d18o, d18osw=0.0, 
                       prior_mean=30.0, prior_std=20.0)
head(quantile(sst))  # Show only the top few values

predictplot(x=bassriver$depth, y=sst, ylim=c(20, 40), 
            ylab="SST (°C)", xlab="Depth (m)")

}
\seealso{
\code{\link{predict_d18oc}}
}
