% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unSurv.R
\name{unSurvDF}
\alias{unSurvDF}
\title{Converts Surv objects in a dataframe to "lo" and "hi" values}
\usage{
unSurvDF(df, suf_lo = "_lo", suf_hi = "_hi")
}
\arguments{
\item{df}{dataframe with Surv objects}

\item{suf_lo}{Column name suffix for "lo" values.  Default = "_lo"}

\item{suf_hi}{Column name suffix for "hi" values.  Default = "_hi"}
}
\value{
Returns dataframe with censored data converted to lo/hi format
}
\description{
Converts Surv objects in a dataframe to "lo" (i.e., lower) and
  "hi" (i.e., upper) values. The user can specify their own values or use the
  defaults.
}
\examples{
df <- dataCensored[dataCensored$station=="CB3.3C", ][1:20,]
colnames(df)
# Default values
df2 <- unSurvDF(df)
colnames(df2)
# User values
df3 <- unSurvDF(df, "_LOW", "_HIGH")
colnames(df3)

}
\seealso{
\code{\link{makeSurvDF}},  \code{\link{unSurv}}
,  \code{\link{impute}},  \code{\link{imputeDF}},  \code{\link{saveDF}},
}
