% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{bdribs.sensitivity}
\alias{bdribs.sensitivity}
\title{sensitivity plot - plot of range of posterior probability corresponding to a range of background rate}
\usage{
bdribs.sensitivity(Y = 5:9, pyr = 800, k = 1, tol = 1.2, bg.evnt = 18,
  bg.pyr = 4000, bg.ci.coef = 0.9, bg.rng = NULL, add.mid = FALSE, ...)
}
\arguments{
\item{Y}{range on number of AESI events for which sensitivity range to be drawn (default = 5:9)}

\item{pyr}{total patient-year exposure where  AESI events occurred (default =800)}

\item{k}{allocation ratio (T:C) (default =1)}

\item{tol}{clinically meaningful relative risk (default =1.2)}

\item{bg.evnt}{background (historical) number of events in the control group (default =18)}

\item{bg.pyr}{background (historical) patient-year exposure in the control group (default =4000)}

\item{bg.ci.coef}{range of background rate estimate to be obtained from bg.ci.coef*100\% CI (default =0.9); takes any value between 0.5 and 0.999.}

\item{bg.rng}{range of background rate - if specified then bg.evnt, bg.pyr, and bg.ci.coef will be ignored (default =NULL)}

\item{add.mid}{indicator variable to plot P(r>tol | Y, pyr) under inf.type=2 - requires related parameters to be supplied (default =F)}

\item{...}{to supply remaining parameters of bdribs call (other than y, pyr, k, bg.events, bg.pyr) for bdribs call when supplied will override the default values}
}
\value{
returns a plot of P(r>tol | Y, pyr) over the range of background rate
}
\description{
plot of range of posterior probability corresponding to a range of background rate
}
\examples{
## Sample calls
     #run 1: The sensitivity plot
     bdribs.sensitivity(Y=5:9,pyr=800,k=1, tol=1.2, bg.evnt=18, bg.pyr=4000,bg.ci.coef=0.90)
     #run 2: The sensitivity plot
     bdribs.sensitivity(Y=5:9,pyr=800,k=1, tol=1.2, bg.evnt=18, bg.pyr=4000,bg.ci.coef=0.90,
     add.mid=TRUE)
     #run 3: Using bg.rng parameter
     bdribs.sensitivity(Y=5:9,pyr=800,k=1, tol=1.2, bg.rng = c(0.0030, 0.0045, 0.0065))
}
