% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_test.R
\docType{data}
\name{data_test_medmod}
\alias{data_test_medmod}
\title{Test Dataset with Moderator
and Mediator}
\format{
A data frame with 200 rows
and five variables:
\describe{
\item{dv}{Dependent variable, continuous}
\item{iv}{Independent variable, continuous}
\item{mod}{Moderator, continuous}
\item{med}{Mediator, continuous}
\item{cov1}{Control variable, continuous}
\item{cov2}{Control variable, continuous}
}
}
\usage{
data_test_medmod
}
\description{
This dataset has one
mediator, one moderator, one
independent variable, one dependent
variable, and two control variables.
}
\examples{

library(lavaan)
mod <-
"
med ~ iv + mod + iv:mod + cov1 + cov2
dv ~ med + iv + cov1 + cov2
"
fit <- sem(mod,
           data_test_medmod)
summary(fit)


}
\keyword{datasets}
