% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biblio_cocitation.R
\name{biblio_cocitation}
\alias{biblio_cocitation}
\title{Calculating the Coupling Angle Measure for Edges in a Co-citation Network}
\usage{
biblio_cocitation(
  dt,
  source,
  ref,
  normalized_weight_only = TRUE,
  weight_threshold = 1,
  output_in_character = TRUE
)
}
\arguments{
\item{dt}{The dataframe with citing and cited documents.}

\item{source}{The column name of the source identifiers, that is the documents that are citing.}

\item{ref}{The column name of the cited references identifiers. In co-citation network, these references are the nodes of the network.}

\item{normalized_weight_only}{If set to FALSE, the function returns the weights normalized by the cosine measure,
but also simply the number of times two references are cited together.}

\item{weight_threshold}{Correspond to the value of the non-normalized weights of edges. The function just keeps the edges
that have a non-normalized weight superior to the \code{weight_threshold}. In a large bibliographic co-citation network,
you can consider for instance that being cited only once together is not sufficient/significant for two references to be linked together.
This parameter could also be modified to avoid creating intractable networks with too many edges.}

\item{output_in_character}{If TRUE, the function ends by transforming the \code{from} and \code{to} columns in character, to make the
creation of a \href{https://tidygraph.data-imaginist.com/index.html}{tidygraph} graph easier.}
}
\value{
A data.table with the articles (or authors) identifier in \code{from} and \code{to} columns,
with one or two additional columns (the coupling angle measure and
the number of shared references). It also keeps a copy of \code{from} and \code{to} in the \code{Source} and \code{Target} columns. This is useful is you
are using the tidygraph package then, where \code{from} and \code{to} values are modified when creating a graph.
}
\description{
This function is basically the same as the \code{\link[=biblio_coupling]{biblio_coupling()}} function but it is explicitly framed
for bibliographic co-citation network (and not for bibliographic coupling networks). It takes a data frame
with direct citations, and calculates the number of times two references are citing together, and calculate a measure
similar to the coupling angle value \insertCite{sen1983}{biblionetwork}: it divides the number of times two references are
cited together by the square root of the product of the total number of citations (in the whole corpus) of each reference.
The more two references are cited in general, the more they have to be cited together for their link to be important.
}
\details{
This function uses data.table package and is thus very fast. It allows the user to compute the coupling angle
on a very large data frame quickly.
}
\examples{
library(biblionetwork)
biblio_cocitation(Ref_stagflation,
source = "Citing_ItemID_Ref",
ref = "ItemID_Ref")

# It is basically the same as:
biblio_coupling(Ref_stagflation,
source = "ItemID_Ref",
ref = "Citing_ItemID_Ref")

}
\references{
\insertAllCited{}
}
