% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{plot_pls_biplot}
\alias{plot_pls_biplot}
\title{PLS biplot}
\usage{
plot_pls_biplot(
  object,
  comps = c(1L, 2L),
  scale_variables = 1,
  circle = TRUE,
  circle_col = "grey85",
  arrow_col = "firebrick",
  groups = NULL,
  ellipse = TRUE,
  ellipse_level = 0.95,
  ellipse_n = 200L,
  group_col = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted PLS model with scores and loadings.}

\item{comps}{Components to display.}

\item{scale_variables}{Scaling factor applied to variable loadings.}

\item{circle}{Logical; draw a unit circle behind loadings.}

\item{circle_col}{Colour of the unit circle guide.}

\item{arrow_col}{Colour for loading arrows.}

\item{groups}{Optional factor or character vector defining groups for
individuals. When supplied, group-specific colours are used and, if
\code{ellipse = TRUE}, confidence ellipses are drawn for each group.}

\item{ellipse}{Logical; draw group confidence ellipses when \code{groups} are
provided.}

\item{ellipse_level}{Confidence level for group ellipses (between 0 and 1).}

\item{ellipse_n}{Number of points used to draw each ellipse.}

\item{group_col}{Optional vector of colours for the groups. Recycled as
needed.}

\item{...}{Additional arguments passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\value{
Invisibly returns \code{NULL} after drawing the biplot.
}
\description{
PLS biplot
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
plot_pls_biplot(fit)
}
