% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{plot_pls_vip}
\alias{plot_pls_vip}
\title{Plot Variable Importance in Projection (VIP)}
\usage{
plot_pls_vip(
  object,
  comps = NULL,
  threshold = 1,
  palette = c("#4575b4", "#d73027"),
  ...
)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{comps}{Components to aggregate. Defaults to all available.}

\item{threshold}{Optional threshold to highlight influential variables.}

\item{palette}{Colour palette used for bars.}

\item{...}{Additional parameters passed to \code{\link[graphics:barplot]{graphics::barplot()}}.}
}
\value{
Invisibly returns the VIP scores used to create the bar plot.
}
\description{
Plot Variable Importance in Projection (VIP)
}
\examples{
set.seed(123)
X <- matrix(rnorm(40), nrow = 10)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(10, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
plot_pls_vip(fit)
}
