% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_cv_select}
\alias{pls_cv_select}
\title{Select components from cross-validation results}
\usage{
pls_cv_select(cv_result, metric = c("rmse", "mae", "r2"), minimise = NULL)
}
\arguments{
\item{cv_result}{Result returned by \code{\link[=pls_cross_validate]{pls_cross_validate()}}.}

\item{metric}{Metric to optimise.}

\item{minimise}{Logical; whether the metric should be minimised.}
}
\value{
Selected number of components.
}
\description{
Select components from cross-validation results
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
cv <- pls_cross_validate(X, y, ncomp = 2, folds = 3)
pls_cv_select(cv, metric = "rmse")
}
