% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_to_mat.R
\name{net_to_mat}
\alias{net_to_mat}
\title{Create a contingency table from a data.frame}
\usage{
net_to_mat(
  net,
  weight = FALSE,
  squared = FALSE,
  symmetrical = FALSE,
  missing_value = 0
)
}
\arguments{
\item{net}{A two- or three-column \code{data.frame} where each row
represents the interaction between two nodes (e.g., site and species),
with an optional third column indicating the weight of the interaction.}

\item{weight}{A \code{logical} value indicating whether the weight column
should be considered.}

\item{squared}{A \code{logical} value indicating whether the output matrix
should be square (i.e., containing the same nodes in rows and columns).}

\item{symmetrical}{A \code{logical} value indicating whether the resulting
matrix should be symmetrical. This applies only if \code{squared = TRUE}.
Note that different weights associated with opposite pairs already present
in \code{net} will be preserved.}

\item{missing_value}{The value to assign to pairs of nodes not present
in \code{net}. Defaults to \code{0}.}
}
\value{
A \code{matrix} with the first nodes (from the first column of \code{net})
as rows and the second nodes (from the second column of \code{net}) as columns.
If \code{squared = TRUE}, the rows and columns will have the same number of
elements, corresponding to the unique union of objects in the first and
second columns of \code{net}. If \code{squared = TRUE} and \code{symmetrical = TRUE},
the matrix will be forced to be symmetrical based on the upper triangular
part of the matrix.
}
\description{
This function generates a contingency table from a two- or three-column
\code{data.frame}, where each row represents the interaction between two
nodes (e.g., site and species) and an optional third column indicates
the weight of the interaction (if \code{weight = TRUE}).
}
\examples{
net <- data.frame(
  Site = c(rep("A", 2), rep("B", 3), rep("C", 2)),
  Species = c("a", "b", "a", "c", "d", "b", "d"),
  Weight = c(10, 100, 1, 20, 50, 10, 20)
)

mat <- net_to_mat(net, weight = TRUE)

}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a2_matrix_and_network_formats.html}.

Associated functions:
\link{mat_to_net}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}) \cr
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com})
}
