% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{prediction}
\alias{prediction}
\title{Predict samples to display on the biplot}
\usage{
prediction(bp, predict.samples = NULL, predict.means = NULL, which = 1:bp$p)
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{predict.samples}{a vector specifying which samples to predict.}

\item{predict.means}{a vector specifying which group means to predict.}

\item{which}{a vector specifying which variable to do the prediction.}
}
\value{
A list object called \code{predict} appended to the object of class \code{biplot} with the following elements:
\item{samples}{a vector of indices of samples which are being predicted.}
\item{predict.means}{a vector of group names of groups for which the means are being predicted.}
\item{which}{the vector of indices variables which are being predicted.}
\item{predict.mat}{the matrix of predicted samples.}
\item{predict.means.mat}{the matrix of predicted group means.}
}
\description{
This function makes predictions of sample points, variables and means and displays them on the biplot.
}
\examples{
biplot(data = iris[,1:4]) |> PCA(group.aes=iris[,5], show.class.means = TRUE) |> 
prediction(141:145,1:3) |> plot()

}
