% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_class.R
\name{bi_class}
\alias{bi_class}
\title{Create Classes for Bivariate Maps}
\usage{
bi_class(.data, x, y, style, dim = 3, keep_factors = FALSE, dig_lab = 3, na_rm = FALSE)
}
\arguments{
\item{.data}{A data frame, tibble, or \code{sf} object}

\item{x}{The \code{x} variable, either a numeric (including double and integer
classes) or factor}

\item{y}{The \code{y} variable, either a numeric (including double and integer
classes) or factor}

\item{style}{A string identifying the style used to calculate breaks. Currently
    supported styles are \code{"quantile"}, \code{"equal"}, \code{"fisher"},
    and \code{"jenks"}. If both \code{x} and \code{y} are factors, this argument can
    be omitted.

    Note that older versions of \code{biscale} used \code{"quantile"} as the default
    for this argument. Now that \code{bi_class} accepts factors, this argument
    no longer as a default and older code will error.}

\item{dim}{The dimensions of the palette. To use the built-in palettes,
    this value must be either \code{2}, \code{3}, or \code{4}. A value of
    \code{3}, for example, would be used to create a three-by-three bivariate
    map with a total of 9 classes.

    If you are using a custom palette, this value may be larger (though these
    maps can be very hard to interpret).

    If you are using pre-made factors, both factors must have the same number
    of levels as this value.}

\item{keep_factors}{A logical scalar; if \code{TRUE}, the intermediate factor
variables created as part of the calculation of \code{bi_class} will be
retained. If \code{FALSE} (default), they will not be returned.}

\item{dig_lab}{An integer that is passed to \code{base::cut()}}

\item{na_rm}{A logical scalar that is passed to \code{classInt::classIntervals()};
if \code{TRUE}, \code{NA} values will be removed prior to calculating breaks.
If \code{FALSE} (default), they will be included.}
}
\value{
A copy of \code{.data} with a new variable \code{bi_class} that contains
    combinations of values that correspond to an observations values for \code{x}
    and \code{y}. This is the basis for applying a bivariate color palette.
}
\description{
Creates mapping classes for a bivariate map. These data will be stored
    in a new variable named \code{bi_class}, which will be added to the given
    data object.
}
\examples{
# quantile breaks, 2x2
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "quantile", dim = 2)

# summarize quantile breaks, 2x2
table(data$bi_class)

# quantile breaks, 3x3
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "quantile", dim = 3)

# summarize quantile breaks, 3x3
table(data$bi_class)

}
