% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-sints-exp-golomb.R
\name{sint_to_exp_golomb_bits}
\alias{sint_to_exp_golomb_bits}
\alias{exp_golomb_bits_to_sint}
\title{Convert between signed integers and Exponential-Golomb bit sequences}
\usage{
sint_to_exp_golomb_bits(x)

exp_golomb_bits_to_sint(bits, n = 1)
}
\arguments{
\item{x}{integer vector with all values >= 0}

\item{bits}{logical vector of bit values}

\item{n}{number of values to decode. Default: 1. Set to 'Inf' to decode 
all bits.  Will raise an error if there are extra bits at the end that
are unused.}
}
\value{
logical vector of bit values, or vector of signed integers
}
\description{
Convert between signed integers and Exponential-Golomb bit sequences
}
\examples{
bits <- sint_to_exp_golomb_bits(c(0, 4, -21))
bits
exp_golomb_bits_to_sint(bits, n = 3)
}
