% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandr.statistics.formula.R
\name{blandr.statistics.formula}
\alias{blandr.statistics.formula}
\title{Bland-Altman statistics for R - submitting data as a formula}
\usage{
blandr.statistics.formula(formula, data = parent.frame(), ...)
}
\arguments{
\item{formula}{A formula, to be eventually passed to the blandr.statistics function}

\item{data}{A data frame}

\item{...}{other arguments.}
}
\description{
If data is supplied as a formula, the function interprets it
and then passes it through to the main blandr.statistics function.
}
\note{
This was initially packaged in the same file as the blandr.statistics function. Changes to R package checks made it easier to separate it out, but functionally it has not changed.
}
\examples{

# Generates two random measurements
measurement1 <- rnorm(100)
measurement2 <- rnorm(100)

# Generates Bland-Altman statistics data of the two measurements using the formula interface

blandr.statistics.formula( measurement2 ~ measurement1 )

# Example with a real data set
blandr.statistics.formula( Method.B ~ Method.A, data = giavarina.2015 )

}
\author{
Deepankar Datta \href{mailto:deepankar.datta@gmail.com}{deepankar.datta@gmail.com}
}
