% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_statistics.R
\docType{class}
\name{Student-class}
\alias{Student-class}
\alias{Student}
\alias{setupStudent}
\title{Student's t test}
\usage{
setupStudent(
  alpha,
  beta,
  r = 1,
  delta,
  delta_NI = 0,
  alternative = c("greater", "smaller"),
  n_max = Inf,
  ...
)
}
\arguments{
\item{alpha}{One-sided type I error rate.}

\item{beta}{Type II error rate.}

\item{r}{Allocation ratio between experimental and control group.}

\item{delta}{Difference of effect size between alternative and null hypothesis.}

\item{delta_NI}{Non-inferiority margin.}

\item{alternative}{Does the alternative hypothesis contain greater
(\code{greater}) or smaller (\code{smaller}) values than the
null hypothesis.}

\item{n_max}{Maximal overall sample size. If the recalculated sample size
is greater than \code{n_max} it is set to \code{n_max}.}

\item{...}{Further optional arguments.}
}
\value{
An object of class \code{\link{Student}}.
}
\description{
This class implements Student's t-test for superiority and non-inferiority
tests.
A trial with continuous outcomes of the two groups \code{E} and \code{C}
is assumed.
If \code{alternative == "greater"} the null hypothesis for the
mean difference \eqn{\Delta = \mu_E - \mu_C} is
\deqn{H_0: \Delta \leq -\delta_{NI} \textrm{ vs. } H_1: \Delta > -\delta_{NI}.}
Here, \eqn{\delta_{NI} \geq 0} denotes the non-inferiority margin.
For superiority trials,\eqn{\delta_{NI}} can be set to zero (default).
If \code{alternative=="smaller"}, the direction of the effect is changed.

The function \code{setupStudent} creates an object of class
\code{\link{Student}} that can be used for sample size recalculation.
}
\details{
The nuisance parameter is the variance \eqn{\sigma^2}.
Within the blinded sample size recalculation procedure, it is re-estimated by
the one-sample variance estimator that is defined by
\deqn{\widehat{\sigma}^2
:= \frac{1}{n_1-1} \sum_{j \in \{T, C \}}
 \sum_{k=1}^{n_{1,j}}(x_{j,k} - \bar{x} )^2,}
where \eqn{x_{j,k}} is the outcome of patient \eqn{k} in group \eqn{j},
\eqn{n_{1,j}} denotes the first-stage sample size in group \eqn{j} and
\eqn{\bar{x}} equals the mean over all \eqn{n_1} observations.
The following methods are available for this class:
\code{\link{toer}}, \code{\link{pow}}, \code{\link{n_dist}},
\code{\link{adjusted_alpha}}, and \code{\link{n_fix}}.
Check the design specific documentation for details.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 3.5, delta_NI = 0,
                  alternative = "greater", n_max = 156)
}
\references{
Lu, K. (2019).
Distribution of the two-sample t-test statistic following blinded
sample size re-estimation. Pharmaceutical Statistics 15(3): 208-215.
}
