% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bliss_Simulated_Annealing.R
\name{Bliss_Simulated_Annealing}
\alias{Bliss_Simulated_Annealing}
\title{Bliss_Simulated_Annealing}
\usage{
Bliss_Simulated_Annealing(
  beta_sample,
  posterior_sample,
  param,
  verbose_cpp = FALSE
)
}
\arguments{
\item{beta_sample}{a matrix. Each row is a coefficient function computed from the
posterior sample.}

\item{posterior_sample}{a list resulting from the \code{Bliss_Gibbs_Sampler}
function.}

\item{param}{a list containing:
\describe{
\item{grids}{a list of numerical vectors, the qth vector is the grid of
       time points for the qth functional covariate.}
\item{basis}{a character (optional). The possible values are "uniform"
      (default), "epanechnikov", "gauss" and "triangular" which correspond to
      different basis functions to expand the coefficient function and the
      functional covariates}
\item{burnin}{an integer (optional), the number of iteration to drop from the
      posterior sample.}
\item{iter_sann}{an integer (optional), the number of iteration of the Simulated
      Annealing algorithm.}
\item{k_max}{an integer (optional), the maximal number of intervals for the
      Simulated Annealing algorithm.}
\item{l_max}{an integer (optional), the maximal interval length for the
      Simulated Annealing algorithm.}
\item{Temp_init}{a nonnegative value (optional), the initial temperature for
     the cooling function of the Simulated Annealing algorithm.}
\item{Q}{an integer, the number of functional covariates.}
\item{p}{a vector of integers, the numbers of time point of each functional
     covariate.}
\item{verbose}{write stuff if TRUE (optional).}
}}

\item{verbose_cpp}{Rcpp writes stuff if TRUE (optional).}
}
\value{
a list containing:
\describe{
 \item{Bliss_estimate}{a numerical vector, corresponding to the Bliss estimate
       of the coefficient function.}
 \item{Smooth_estimate}{a numerical vector, which is the posterior expectation
       of the coefficient function for each time points.}
 \item{trace}{a matrix, the trace of the algorithm.}
}
}
\description{
A Simulated Annealing algorithm to compute the Bliss estimate.
}
\examples{
\donttest{
data(data1)
data(param1)
data(res_bliss1)
param1$Q <- length(data1$x)
param1$grids <- data1$grids
param1$p <- sapply(data1$grids,length)

posterior_sample <- res_bliss1$posterior_sample
beta_sample <- compute_beta_sample(posterior_sample,param1)

res_sann <- Bliss_Simulated_Annealing(beta_sample,posterior_sample,param1)
}
}
