% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R, R/utils-pkg.R
\name{set_names}
\alias{set_names}
\alias{paste_enum}
\alias{coal}
\alias{reval}
\alias{reval_if}
\alias{unlst}
\alias{pkg_name}
\alias{pkg_version}
\alias{pkg_file}
\alias{pkg_avail}
\title{Miscellaneous utilities}
\usage{
set_names(object = nm, nm)

paste_enum(x, sep = ", ", conj = " and ", quotes = "`")

coal(..., fail_all = TRUE, test_fun = is.null)

reval(x)

reval_if(x)

unlst(x, recursive = FALSE, use_names = FALSE)

pkg_name(env = parent.frame())

pkg_version(pkg = parent.frame())

pkg_file(..., pkg = parent.frame())

pkg_avail(...)
}
\arguments{
\item{object, nm}{See \code{\link[stats:setNames]{stats::setNames()}}}

\item{x}{Character vector to \code{\link[base:paste]{base::paste()}}}

\item{sep, conj}{Separation strings for all but last and last positions}

\item{quotes}{Quotes to wrap each entry in \code{x} with}

\item{...}{Set of objects to iterate over}

\item{fail_all}{Error if no non-null objects are present}

\item{test_fun}{Function to test each element with}

\item{recursive, use_names}{See \code{\link[base:unlist]{base::unlist()}}}

\item{env}{An environment that is resolved to a package name}

\item{pkg}{A string.valued package name or an environment passed to
\code{\link[=pkg_name]{pkg_name()}}}
}
\value{
Function \code{set_names()} returns a names object, \code{paste_enum()} a
string, \code{coal()} the first non-null object and \code{unlst()} performs the same
action as \code{\link[base:unlist]{base::unlist()}} but with differing defaults.
}
\description{
Several internal utility functions are exported for convenience in case
dependent packages can make use of this functionality.
}
\keyword{internal}
