% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectlattice.R
\name{rectlattice}
\alias{rectlattice}
\title{Rectangular lattice designs}
\usage{
rectlattice(v, r)
}
\arguments{
\item{v}{is the required block size and must be the integer square root of the required number of treatments}

\item{r}{is the required number of replicates}
}
\description{
Internal function constructs rectangular lattice designs for resolvable nested block designs with 
v*(v-1) treatments, r complete replicate blocks and nested blocks of size v. 

Returns a rectangular lattice for v*(v-1) treatments and r replicates whenever a square lattice with v*v  
treatments and r+1 replicates exists; see \code{\link[blocksdesign]{squarelattice}} for square lattice designs.

See Cochran and Cox, Experimental Designs, 2nd Edition, Page 417 (Shrikhande method).
}
\references{
Cochran, W.G., and G.M. Cox. 1957. Experimental Designs, 2nd ed., Wiley, New York.
}
\keyword{internal}
