% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{grid_diversity}
\alias{grid_diversity}
\title{Compute diversities for a collection of spatial interaction models}
\usage{
grid_diversity(
  sim,
  definition = c("shannon", "renyi", "ND", "RW"),
  order = 1L,
  activity = c("destination", "attractiveness"),
  ...
)
}
\arguments{
\item{sim}{a collection of spatial interaction models, an object of class
\code{sim_list}}

\item{definition}{diversity definition \code{"shannon"} (default), \code{"renyi"} (see
details) or a definition supported by  \code{\link[=terminals]{terminals()}}}

\item{order}{order of the Rényi entropy, used only when \code{definition="renyi"}}

\item{activity}{specifies whether the diversity is computed based on the
destination flows (for \code{activity="destination"}, the default case) or on
the attractivenesses (for \code{activity="attractiveness"}).}

\item{...}{additional parameters}
}
\value{
a vector of diversities, one per spatial interaction model
}
\description{
The function computes for each spatial interaction model of its \code{sim_list}
parameter the \code{\link[=diversity]{diversity()}} of the corresponding destination flows and
returns the values as a vector. The type of diversity and the associated
parameters are identical for all models.
}
\details{
See \code{\link[=diversity]{diversity()}} for the definition of the diversities. Notice that
\code{\link[=diversity]{diversity()}} is generic and can be applied directly to \code{sim_list} objects.
The current function is provided to be explicit in R code about what is a
unique model and what is a collection of models (using function names that
start with \code{"grid_"})
}
\examples{
distances <- french_cities_distances[1:15, 1:15] / 1000 ## convert to km
production <- log(french_cities$population[1:15])
attractiveness <- log(french_cities$area[1:15])
all_flows <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1,
  bipartite = FALSE
)
diversities <- grid_diversity(all_flows)
diversities ## should be a length 12 vector
grid_diversity(all_flows, "renyi", 3)
}
\seealso{
\code{\link[=diversity]{diversity()}} and \code{\link[=grid_blvim]{grid_blvim()}}
}
