% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-main.R
\docType{package}
\name{bmscstan}
\alias{bmscstan}
\title{Bayesian Multilevel Single Case models using 'Stan'}
\description{
The \strong{bmscstan} package provides an interface to fit Bayesian
Multilevel Single Case models.
These models compare the performance of a Single Case against a control
group, combining
the flexibility of multilevel models and the potentiality of Bayesian
Statistics.
}
\details{
The package is now limited to gaussian data only, but we will further expand
it to cover
binomial and ordinal (Likert scales) data.

By means of \strong{bmscstan} the effects of the control group and the
effects of the deviance between the
Single Case and the group will be estimated.

The model to estimate the controls parameters is:

\ifelse{html}{\out{<p style="text-align:center;text-style:italic;">y~N(&beta; X + b Z, &sigma;<sup>2</sup>)</p>}}{\eqn{y~N(\beta X + b Z, \sigma^2)}}


where \eqn{y} is the controls' dependent variable, \eqn{X} the contrast
matrix for Population-level (or Fixed)
Effects, and \eqn{\beta} are the unknown coefficients to be estimate. \eqn{Z}
is the contrast matrix for the
Varying (or Random, or Group-level) effects, and \eqn{b} are the unknown
estimates for the varying effects.
\eqn{\sigma^2} is the variance.

In order to estimate the coefficients of the Single Case, the formula is the following:

\ifelse{html}{\out{<p style="text-align:center;text-style:italic;">y<sub>pt</sub>~N(&phi; X<sub>pt</sub>, &sigma;<sup>2</sup><sub>pt</sub>)</p>}}{\eqn{y_{pt}~N(\phi X_{pt}, \sigma_{pt}^2)}}

where \eqn{\phi = \beta + \delta}.

The validation of the approach can be found here:
https://www.doi.org/10.31234/osf.io/sajdq
}
\section{Details}{

The main function of \strong{bmscstan} is \code{\link{BMSC}}, which uses formula syntax to
specify your model.
}

