% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.outliers.R
\name{check.outliers}
\alias{check.outliers}
\title{Indentifies and gives an option to remove outliers}
\usage{
check.outliers(data.to.work, ask.before)
}
\arguments{
\item{data.to.work}{is a data set with variables to be checked.}

\item{ask.before}{control if the process will ask for confirmation or not.}
}
\description{
This function receives a data set, scan all variables e for each one, verifies if there are outliers and ask if we wish to remove them. We can pass a parameter where we set if the function remove it automatically or will ask before.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Load the data set
data(dataQuantC) # Pre-Loaded
# Set a variable to ask before remove outlier or not
ask.before = "Y" # or ask.before = "N"
# Call the procedure to check if there are outliers
dataQuantC <- check.outliers(dataQuantC, ask.before)
}
\author{
Elias Carvalho
}
