% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate_batch_edit_functions.R
\name{boilerplate_find_chars}
\alias{boilerplate_find_chars}
\title{Find Entries with Specific Characters in Fields}
\usage{
boilerplate_find_chars(
  db,
  field,
  chars,
  exclude_entries = NULL,
  category = NULL
)
}
\arguments{
\item{db}{List. The database to search.}

\item{field}{Character. The field to check.}

\item{chars}{Character vector. Characters to search for.}

\item{exclude_entries}{Character vector. Entries to exclude from results.}

\item{category}{Character. Category if db is unified.}
}
\value{
A named list of entries containing the specified characters.
}
\description{
This helper function finds all entries containing specific characters in a field.
Useful for identifying which entries need cleaning.
}
\examples{
\donttest{
# First create a sample database
unified_db <- list(
  measures = list(
    test1 = list(reference = "@Smith2023[p.45]"),
    test2 = list(reference = "Jones (2022)"),
    test3 = list(reference = "Brown[2021]")
  )
)

# Find all entries with @, [, or ] in references
entries_to_clean <- boilerplate_find_chars(
  db = unified_db,
  field = "reference",
  chars = c("@", "[", "]"),
  category = "measures"
)

# Find entries but exclude specific ones
entries_to_clean <- boilerplate_find_chars(
  db = unified_db,
  field = "reference",
  chars = c("@", "[", "]"),
  exclude_entries = c("forgiveness", "special_*"),
  category = "measures"
)
}

}
