% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/version-management.R
\name{boilerplate_restore_backup}
\alias{boilerplate_restore_backup}
\title{Restore Database from Backup}
\usage{
boilerplate_restore_backup(
  category = NULL,
  backup_version = NULL,
  data_path = NULL,
  restore = FALSE,
  confirm = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{category}{Character. Category to restore, or NULL for unified database.}

\item{backup_version}{Character. Specific backup timestamp (format: "YYYYMMDD_HHMMSS"),
or NULL to use the latest backup.}

\item{data_path}{Character. Path to directory containing backup files.
If NULL (default), uses tools::R_user_dir("boilerplate", "data").}

\item{restore}{Logical. If TRUE, saves the backup as the current standard file
(overwrites existing). If FALSE (default), just returns the backup content.}

\item{confirm}{Logical. If TRUE (default), asks for confirmation before overwriting.
Ignored if restore = FALSE.}

\item{quiet}{Logical. If TRUE, suppresses messages. Default is FALSE.}
}
\value{
The restored database (invisibly if restore = TRUE).
}
\description{
Convenience function to restore a database from backup files. Can either
import the backup for inspection or restore it as the current database.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise and create some content
boilerplate_init(data_path = temp_dir, categories = "methods",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)

# Create a backup by saving with timestamp
boilerplate_save(db, data_path = temp_dir, timestamp = TRUE,
                 confirm = FALSE, quiet = TRUE)

# List available files to see backup
files <- boilerplate_list_files(data_path = temp_dir)

# Create a proper backup by using create_backup parameter
boilerplate_save(db, data_path = temp_dir, create_backup = TRUE,
                 confirm = FALSE, quiet = TRUE)

# Now list files again to see the backup
files <- boilerplate_list_files(data_path = temp_dir)

# View latest backup without restoring
if (nrow(files$backups) > 0) {
  backup_db <- boilerplate_restore_backup(data_path = temp_dir)
}

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{boilerplate_list_files}} to see available backups,
\code{\link{boilerplate_import}} for general import functionality.
}
