#'Calculates desired extra compensation (in terms of bps) for a risky Bond as compared Annual Percentage Rate(APR) of a comparable Bond.
#'@details
#'The additional compensation for the greater risk in Bond B is 20.9 bps (0.10839 – 0.10630 = 0.00209) when the yields are stated on a semi-annual bond basis. The additional compensation is 20.4 bps (0.10696 – 0.10492 = 0.00204) when both are annualized for quarterly compounding (Adams & Smith, 2019).
#'In light of the information given,  \code{extraCompensationForHigherRisk()} desired extra compensation for a risky Bond as compared Annual Percentage Rate (APR) of a comparable Bond for values passed to its two arguments. Here, \code{APRofRiskyBond} is given Annual Percentage Rate of risky bond, and \code{APRofComparableBond} is given Annual Percentage Rate of comparable Bond. The output of 20.9 means 20.9 bps.
#'@param APRofRiskyBond A number.
#'@param APRofComparableBond A number.
#'@return Input values to two arguments  \code{APRofRiskyBond} and \code{APRofComparableBond}.
#'@importFrom Rdpack reprompt
#'@author MaheshP Kumar, \email{maheshparamjitkumar@@gmail.com}
#'@references
#'Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, <https://bookshelf.vitalsource.com/books/9781119593577>
#'@examples
#'extraCompensationForHigherRisk(APRofRiskyBond=0.10839,APRofComparableBond=0.10630)
#'@export
extraCompensationForHigherRisk <- function (APRofRiskyBond,APRofComparableBond)
{
  (extraCompensation<- (APRofRiskyBond-APRofComparableBond)*100*100)
}


