% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d09_computingEffDurationCallableBond.R
\name{effDurtnCallableBond}
\alias{effDurtnCallableBond}
\title{Calculates the Effective Duration statistic of a Callable Bond.}
\usage{
effDurtnCallableBond(pvBase, pvPlus, pvMinus, perChangeBenchYtm)
}
\arguments{
\item{pvBase}{A number.}

\item{pvPlus}{A number.}

\item{pvMinus}{A number.}

\item{perChangeBenchYtm}{A number.}
}
\value{
Input values to four arguments  \code{pvBase},\code{pvPlus} ,\code{pvMinus}  and \code{perChangeBenchYtm}.
}
\description{
Calculates the Effective Duration statistic of a Callable Bond.
}
\details{
According to information provided by Adams and Smith (2019), the method \code{effDurtnCallableBond()} is developed to calculate the Effective Duration statistic of a Callable Bond.
}
\examples{
effDurtnCallableBond(pvBase=101.060489,pvPlus=99.050120,pvMinus=102.890738,perChangeBenchYtm=0.0025)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Understanding Fixed‑Income Risk and Return. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 237-299). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
