% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootsemi.R
\name{bootsemi}
\alias{bootsemi}
\title{Semiparametric Bootstrap}
\usage{
bootsemi(
  x,
  func,
  B,
  model = c("ARIMA", "GARCH"),
  params,
  model.fit = NULL,
  model.sim = NULL,
  H0 = FALSE,
  PAR0 = NULL,
  ...
)
}
\arguments{
\item{x}{A vector or a time series representing the data.}

\item{func}{The function to apply to each sample.}

\item{B}{A positive integer; the number of bootstrap replications.}

\item{model}{The chosen model to fit the time series. Either "ARIMA" or "GARCH", else
\code{model.fit} and \code{model.sim} should be specified.}

\item{params}{The parameters of the model (see below).}

\item{model.fit}{A function fitting the parameters for the generic model (see below).
By default \code{NULL}.}

\item{model.sim}{A function simulating the data for the generic model (see below). By default
\code{NULL}.}

\item{H0}{Logical. Only implemented for the ARIMA and GARCH models.
If \code{H0 = TRUE}, the value(s) of the parameter(s) under the null
\code{PAR0} should be specified. Then, the model is simulated
under the null hypothesis. By default it is \code{NULL}.}

\item{PAR0}{The value of the parameter that we want to test under the null hypothesis.
By default it is \code{FALSE}.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
\code{bootsemi} returns an object of class \code{boodd}
(see \link{class.boodd}).
}
\description{
The function performs a semiparametric bootstrap for a general
statistics, using a time-series model.
}
\details{
The default basic models currently supported are : \emph{ARIMA} and \emph{GARCH}.

The argument \code{params} specifies the orders of the chosen model. In
the case of \emph{ARIMA}, it is a vector of the form \emph{c(p,q)} or
\emph{c(p,d,q)}. In the case of \emph{GARCH}, it is a vector of the form
\emph{c(q)} or \emph{c(p,q)} corresponding to an \emph{ARCH(q)} or
\emph{GARCH(p,q)} model, respectively.

Alternatively, one can specify two functions in the \code{model.fit}  and
\code{model.sim} arguments. They are used to implement a generic bootstrap procedure, which
first estimates the model with \code{model.fit} and then simulates the bootstrap time series
with \code{model.sim}. The
\code{model.fit} function has the following prototype:
\preformatted{
    model.fit(x,params)
  }
It receives the \code{params} argument specified in the \code{bootsemi} function.
It should return an object describing the model (typically a list
containing all the necessary components for the model). The
\code{model.sim} function has the following prototype:
\preformatted{
    model.sim(model,innovations,params)
  }
The \code{innovations} argument is the resampled vector of centered residuals.
The function builds a new trajectory of the original process using the
estimators provided by the \code{model.fit} function.

The Examples section below shows how this can be done in the case of a
Threshold Autoregressive (\emph{TAR}) process.

Parameters \code{HO} and \code{PAR0} may be used to generate the bootstrap distribution
of the statistic of interest under a specific null hypothesis. This option may be
useful, for instance, for ARIMA models with unit roots. In that case, the usual bootstrap
dose not work, unless one simulates the process under the null hypothesis of unit root.
}
\examples{
\donttest{
# An ARIMA(2,1) process
library(stats)
B <- 299
n <- 200
x <- arima.sim(model=list(ar=c(0.8,-0.4),ma=c(0.2)),n=n)
boo1 <- bootsemi(x,mean,B,model="ARIMA",params=c(2,1))
plot(boo1)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Lahiri, S. N. (2003). \emph{Resampling Methods for Dependent Data}. Springer N.Y..

Shimizu, K. .(2017). \emph{Bootstrapping Stationary ARMA-GARCH Models}.
Springer Fachmedien Wiesbaden.

Park, J.Y. (2003). Bootstrap unit-root tests, \emph{Econometrica}, \bold{77}, 1845-1895.
}
\seealso{
\code{\link{blockboot}},
\code{\link{plot.boodd}},
\code{\link{confint.boodd}}.
}
\keyword{"ARMA"}
\keyword{"Bootstrap}
\keyword{"GARCH"}
\keyword{"Semiparametric}
\keyword{"TAR"}
\keyword{bootstrap"}
\keyword{null"}
\keyword{the}
\keyword{under}
