% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseudoPopBootstrapMethods.R
\name{pseudopop.boot.stsrs}
\alias{pseudopop.boot.stsrs}
\title{Pseudo-population Bootstrap Methods for Survey Data}
\usage{
pseudopop.boot.stsrs(
  data,
  population.size,
  R.pop,
  R.samp,
  parameter = "total",
  bootstrap.method = "Booth.Butler.Hall"
)
}
\arguments{
\item{data}{A vector, matrix or data frame. If it is a matrix or data frame then the column of study variable has to be named \code{study.variable}.  If the sampling design is STSRSWOR, a column identifying strata named \code{stratum} has to be included.}

\item{population.size}{A vector of stratum population sizes}

\item{R.pop}{The number of bootstrap replicates to create bootstrap pseudo-populations}

\item{R.samp}{The number of bootstrap replicates to draw bootstrap samples from each bootstrap pseudo-population}

\item{parameter}{One of the following population parameters can be applied: \code{"total"} (population total), \code{"mean"} (population mean), \code{"quartile.25"} (population 1st quartile), \code{"quartile.50"} or \code{"median"} (population median) or \code{"quartile.75"} (population 3rd quartile). If the parameter of interest is the population mean or total, the HT-estimator is applied. If the parameter of interest is a population quartile, the estimator in Sarndal, Swensson, and Wretman (1992, Chapter 5) is applied. The default is the population total.}

\item{bootstrap.method}{One of the following bootstrap methods can be applied: \code{"Bickel.Freedman"} (Bickel and Freedman, 1984),\code{"Chao.Lo.1985"} (Chao and Lo, 1985), \code{"Sitter.BWO"} (Sitter, 1992), \code{"Booth.Butler.Hall"} (Booth, Butler and Hall, 1994) or \code{"Chao.Lo.1994"} (Chao and Lo, 1994). The default is \code{"Booth.Butler.Hall"}.}
}
\value{
\code{boot.statistic} A vector of bootstrap statistics

\code{boot.parameter} A vector of bootstrap parameters computed on bootstrap pseudo-populations

\code{boot.var} The bootstrap variance estimator of the estimator of parameter of interest

\code{boot.mean} The average of the bootstrap estimator of the parameter of interest

\code{boot.sample} A list of size \code{R.pop}. Each list contains a list of results on each generated bootstrap pseudo-population. This includes three columns: bootstrap values, selected indices in each stratum, and a stratum identifier column.
}
\description{
The function \code{pseudopop.boot.stsrs} applies one of the following pseudo-population bootstrap methods on complete (full response) survey data selected under either SRSWOR or STSRSWOR: Bickel and Freedman (1984), Chao and Lo (1985), Sitter (1992, CJS), Booth, Butler and Hall (1994) and Chao and Lo (1994).
}
\examples{

R.pop<- 5
R.samp<- 10

data(data_samp_srs)
population_size<- 6000
# The sampling fraction is about 30\%.
# data_samp_srs is a sample taken from data_pop available in the package.

boot.Booth<- pseudopop.boot.stsrs(data_samp_srs, population_size, R.pop, R.samp)
boot.Booth$boot.var

boot.BF<- pseudopop.boot.stsrs(data_samp_srs, population_size, R.pop, R.samp,
           bootstrap.method="Bickel.Freedman")
boot.BF$boot.var

boot.Sitter.med<- pseudopop.boot.stsrs(data_samp_srs, population_size, R.pop,
                   R.samp, parameter="median", bootstrap.method="Sitter.BWO")
boot.Sitter.med$boot.var
boot.Sitter.med$boot.sample[[2]][[5]]

data(data_samp_stsrs)
population_size_st<- c(4500, 6300, 3500, 2000, 1500)
# The overall sampling fraction is about 30\%.
# data_samp_stsrs is a sample taken from data_pop_st available in the package.

boot.Booth.st<- pseudopop.boot.stsrs(data_samp_stsrs, population_size_st, R.pop, R.samp)
boot.Booth.st$boot.statistic



}
\references{
Bickel, P. J. and Freedman, D. A. (1984). Asymptotic normality and the bootstrap in stratified sampling. The Annals of Statistics 12, 470–82.

Booth, J. G., Butler, R. W. and Hall, P. (1994). Bootstrap methods for finite populations. Journal of the American Statistical Association 89 (428), 1282–1289.

Chao, M. T. and Lo, S.-H. (1985). A bootstrap method for finite population. Sankhya: The Indian Journal of Statistics, Series A 47, 399–405.

Chao, M. T. and Lo, S.-H. (1994). Maximum likelihood summary and the bootstrap method in structured finite populations. Statistica Sinica 4 (2), 389–406.

Särndal, C.-E., Swensson, B. and Wretman, J. (1992). Model-Assisted Survey Sampling. NewYork: Springer.

Sitter, R. R. (1992). Comparing three bootstrap methods for survey data. The Canadian Journal of Statistics 20 (2), 135–154.
}
