% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_poos_forecast.R
\name{specify_poosf_exercise}
\alias{specify_poosf_exercise}
\title{R6 Class Representing specification of the pseudo-out-of-sample forecasting 
exercise}
\description{
The class \code{POOSForecastSetup} presents the specification of the 
recursive pseudo-out-of-sample forecasting exercise using expanding window
samples.
}
\examples{
spec = specify_bvarPANEL$new(ilo_dynamic_panel)
poos = specify_poosf_exercise$new(spec, 5000, 1000, 1:2, 10)


## ------------------------------------------------
## Method `specify_poosf_exercise$new`
## ------------------------------------------------

spec = specify_bvarPANEL$new(ilo_dynamic_panel)
poos = specify_poosf_exercise$new(spec, 5000, 1000, 1:2, 10)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{S}}{a positive integer number - the number of MCMC draws from the 
posterior distribution in the estimation for each forecasts}

\item{\code{S_burn}}{a positive integer number - the number of MCMC draws from
to achieve convergence in the estimation for each forecasts}

\item{\code{horizons}}{a vector with positive integer numbers - the forecast
horizons used in the forecast performance evaluation}

\item{\code{training_sample}}{a positive integer number - the number of of the
first observations to be used in the estimation for the first forecast}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-POOSForecastSetup-new}{\code{specify_poosf_exercise$new()}}
\item \href{#method-POOSForecastSetup-clone}{\code{specify_poosf_exercise$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-POOSForecastSetup-new"></a>}}
\if{latex}{\out{\hypertarget{method-POOSForecastSetup-new}{}}}
\subsection{Method \code{new()}}{
Create a new specification \code{POOSForecastSetup} of the 
recursive pseudo-out-of-sample forecasting exercise using expanding window
samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_poosf_exercise$new(
  spec,
  S,
  S_burn,
  horizons = 1L,
  training_sample = 1L
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spec}}{a model specification object of class \code{BVARPANEL} or
\code{BVARGROUPPANEL}.}

\item{\code{S}}{a positive integer - number of draws from the posterior 
distribution for model estimation for each of the forecasts}

\item{\code{S_burn}}{a positive integer - number of draws from the posterior 
distribution to obtain convergence for model estimation for each of the 
forecasts}

\item{\code{horizons}}{a vector with positive integers - forecast horizons at 
which forecasting performance is to be verified}

\item{\code{training_sample}}{a positive integer - the number of the first 
observations to be used for estimation for the first forecast. The number 
of observations to be used for remaining forecasts increases recursively 
by one for each forecast.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new specification \code{POOSForecastSetup} of the 
recursive pseudo-out-of-sample forecasting exercise using expanding window
samples.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{spec = specify_bvarPANEL$new(ilo_dynamic_panel)
poos = specify_poosf_exercise$new(spec, 5000, 1000, 1:2, 10)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-POOSForecastSetup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-POOSForecastSetup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_poosf_exercise$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
