% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov.R
\name{bratteliDistances}
\alias{bratteliDistances}
\title{Intrinsic distances}
\usage{
bratteliDistances(Mn, N)
}
\arguments{
\item{Mn}{a function returning for each integer \code{n} the incidence
matrix between levels \code{n} and \code{n+1}; the matrix \code{Mn(0)}
must have one and only one row}

\item{N}{the level up to which the distances are wanted}
}
\value{
The distance matrices in a list.
}
\description{
Intrinsic distances on a Bratteli graph
}
\examples{
# the Pascal graph ####
Pascal <- function(n) {
 M <- matrix(0, nrow = n+1, ncol = n+2)
 for(i in 1:(n+1)) {
   M[i, ][c(i, i+1L)] <- 1
 }
 M
}
bratteliDistances(Pascal, 4)

# the Euler graph ####
Euler <- function(n) {
  M <- matrix(0, nrow = n+1, ncol = n+2)
  for(i in 1:(n+1)) {
    M[i, ][c(i, i+1L)] <- c(i, n+2-i)
  }
  M
}
bratteliDistances(Euler, 4)
}
