% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{binarize.factor}
\alias{binarize.factor}
\title{Create Binary Features based on a Factor Vector}
\usage{
binarize.factor(x, name, y, segments = 10, bin.size = 5)
}
\arguments{
\item{x}{a numeric vector.}

\item{name}{a character string, the variable name of \code{x}.}

\item{y}{a numeric or integer vector of the same length as \code{x}, consisting of two unique values: 0 and 1.}

\item{segments}{a positive integer indicating the maximum number of levels allowed in the factor variable.}

\item{bin.size}{a positive integer. It is the minimum number of observations required to fall into each bin.}
}
\value{
a data frame with binary (0 and 1) entries. The column names are indicative of the conditions used to form the corresponding columns.
}
\description{
Create binary dummy variables based on a factor variable. This function is used internally by \code{\link{binarize}}.
}
