% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\docType{package}
\name{bsnsing-package}
\alias{bsnsing-package}
\title{bsnsing: Build Decision Trees with Optimal Multivariate Splits}
\description{
The bsnsing package provides functions for building a decision tree classifier and making predictions. It solves a mixed-integer programming (MIP) model to maximize the Gini reduction at each node split, and each node split rule can utilize multiple input variables. Benchmarking experiments on 75 open data sets suggest that bsnsing trees are the most capable of discriminating new cases compared to trees trained by other decision tree codes including the rpart, C50, party and tree packages in R. Compared to other optimal decision tree packages, including DL8.5, OSDT, GOSDT and indirectly more, bsnsing stands out in its training speed, ease of use and broader applicability without losing in prediction accuracy. For more information, please check out the paper \url{https://arxiv.org/abs/2205.15263}, to be published in INFORMS Journal on Computing.
}
\section{The ENUM algorithm}{

In this package, the MIP model is solved using the implicit enumeration (ENUM) algorithm. The experimental version at \url{https://github.com/profyliu/bsnsing/} is able to use external solvers such as GUROBI, CPLEX and lpSolve (via specifying the opt.solver option in the \code{\link{bsnsing}} function). All benchmarking experiments were run using the C implementation of the ENUM algorithm, i.e., opt.solver = 'enum_c', which is the default setting.
}

\section{More data sets}{

Several data frames (i.e., \code{\link{auto}}, \code{\link{iris}}, \code{\link{GlaucomaMVF}} and \code{\link{BreastCancer}}) used in the example code are included in this package. More two-class and multi-class classification data sets can be found at \url{https://github.com/profyliu/bsnsing/}.
}

\section{Learn functions}{

The learn (train) functions include \code{\link{bsnsing}}, \code{\link{bsnsing.formula}} and \code{\link{bsnsing.default}}.
}

\section{Predict functions}{

The predict functions include: \code{\link{predict.bsnsing}} and \code{\link{predict.mbsnsing}}.
}

\section{Plot functions}{

A \code{\link{bsnsing}} object (tree) can be plotted into a PDF file, or in the form of latex code, by the function \code{\link{plot.bsnsing}}. The ROC curve can be plotted using the function \code{\link{ROC_func}}.
}

\section{Auxilliary functions}{

Here is a list of internal functions of the package that are open for end users.
\code{\link{summary.bsnsing}}
\code{\link{summary.mbsnsing}},
\code{\link{binarize}},
\code{\link{binarize.numeric}},
\code{\link{binarize.factor}},
\code{\link{binarize.y}},
\code{\link{bslearn}},
\code{\link{bscontrol}}
}

\author{
Yanchao Liu
}
