% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hd.beta.R
\name{hd.beta}
\alias{hd.beta}
\title{HD interval for the beta distribution}
\usage{
hd.beta(c, d, rho = NULL, len = NULL, N = 1000)
}
\arguments{
\item{c}{First parameter of the beta distribution.}

\item{d}{Second parameter of the beta distribution.}

\item{rho}{A number in (0, 1) representing the fixed probability for the HD interval.}

\item{len}{A positive real number representing the fixed length for the HD interval.}

\item{N}{Number of replicates used in the simulation when the length is fixed. Default is 1000.}
}
\value{
Lower and upper bounds of the HD interval.
}
\description{
Computes the highest density interval for the beta distribution by optimization or simulation.
}
\note{
For fixed probability (\code{rho}) of the HD interval the function uses \code{betaHPD} function from \code{pscl} R package. For fixed length of the HD interval the function uses an algorithm proposed in M'Lan et al. (2006). For the case that uses Monte Carlo simulations, the provided interval may vary from one call to the next. The difference is expected to decrease as the number of replicates (\code{N}) increases.
}
\examples{
hd.beta(c = 2, d = 3, rho = 0.95)

hd.beta(c = 2, d = 3, len = 0.3)
}
\references{
M’Lan, C.E., Joseph, L., Wolfson, D.B. (2006). Bayesian sample size determination for case-control studies. Journal of the American Statistical Association, 101, 760–772.
}
