% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_longCombo.R
\name{longCombo}
\alias{longCombo}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven (BE) point at expiration for Long Combo  and draws its graph in the Plots tab.}
\usage{
longCombo(
  ST,
  X1L,
  X2H,
  PX1L,
  CX2H,
  hl = 0,
  hu = 1.9,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Long Combo ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{X2H}{Higher Strike Price or eXercise price.}

\item{PX1L}{Put Premium received for the sold Put at Lower Strike.}

\item{CX2H}{Call Premium paid for the bought Call at higher Strike .}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Long Combo Strangle.
}
\description{
This strategy results from buying an OTM call option with a strike price X2H and selling an OTM put option with a strike price X1L, where X2H is greater than X1L (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and Breakeven (BE) point for Long Combo and draws its graph in the Plots tab.
}
\examples{
longCombo(19,15,25,1.50,2.00)
longCombo(19,15,25,1.50,1.50)
longCombo(19,15,25,1.80,1.50)
longCombo(60,47,57,5,4,hl=0.4,hu=1.4)
longCombo(1000,980,1010,80,80,hl=0.965,hu=1.025)
longCombo(1000,980,1010,80,78,hl=0.965,hu=1.025)
longCombo(1000,980,1010,76,78,hl=0.965,hu=1.025)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
