% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_strapGraph.R
\name{strapStrategy}
\alias{strapStrategy}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven point at expiration for Strap Strategy and draws its graph in the Plots tab.}
\usage{
strapStrategy(
  ST,
  X,
  C1,
  C2,
  P1,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Strap Strategy ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C1}{Call Premium paid on bought first call.}

\item{C2}{Call Premium paid on bought second call.}

\item{P1}{Put Premium paid on bought Put.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Strap Strategy.
}
\description{
This is a volatility strategy consisting of a long position in two ATM call options, and a long position in an ATM put option with a strike price K. This is a net debit trade. The trader or investor has bullish outlook (Kakushadze & Serur, 2018) .
}
\details{
This method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for a Strap Strategy and draws its graph in the Plots tab.
}
\examples{
strapStrategy(25,25,2.40,2.40,1.70)
strapStrategy(40,40,3,3,2,hl=0.7,hu=1.2)
strapStrategy(1000,1010,18,18,10,hl=0.955,hu=1.055)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
