% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{estimated_hiv_transmission_flows}
\alias{estimated_hiv_transmission_flows}
\title{Estimated HIV transmission flows}
\format{
A data frame:
\describe{
\item{H1_group}{Name of population group 1}
\item{H2_group}{Name of population group 2}
\item{number_hosts_sampled_group_1}{Number of individuals sampled from population group 1}
\item{number_hosts_sampled_group_2}{Number of individuals sampled from population group 2}
\item{number_hosts_population_group_1}{Estimated number of individuals in population group 1}
\item{number_hosts_population_group_2}{Estimated number of individuals in population group 2}
\item{max_possible_pairs_in_sample}{Number of distinct possible transmission pairs between individuals sampled from population groups 1 and 2}
\item{max_possible_pairs_in_population}{Number of distinct possible transmission pairs between individuals in population groups 1 and 2}
\item{num_linked_pairs_observed}{Number of observed directed transmission pairs between samples from population groups 1 and 2}
\item{p_hat}{Probability that pathogen sequences from two individuals randomly sampled from their respective population groups are linked}
\item{est_linkedpairs_in_population}{Estimated transmission pairs between population groups 1 and 2}
\item{theta_hat}{Estimated transmission flows or relative probability of transmission within and between population groups 1 and 2 adjusted
for sampling heterogeneity. More precisely, the conditional probability that a pair of pathogen sequences is from a specific population
group pairing given that the pair is linked.}
\item{obs_trm_pairs_est_goodman}{Point estimate, Goodman method Confidence intervals for observed transmission pairs}
\item{obs_trm_pairs_lwr_ci_goodman}{Lower bound of Goodman confidence interval}
\item{obs_trm_pairs_upr_ci_goodman}{Upper bound of Goodman confidence interval}
\item{est_goodman}{Point estimate, Goodman method Confidence intervals for estimated transmission flows}
\item{lwr_ci_goodman}{Lower bound of Goodman confidence interval}
\item{upr_ci_goodman}{Upper bound of Goodman confidence interval}
\item{prob_group_pairing_and_linked}{Probability that a pair of pathogen sequences is from a specific population group pairing and is linked}
\item{c_hat}{Probability that a randomly selected pathogen sequence in one population group links to at least
one pathogen sequence in another population group i.e. probability of clustering}
\item{est_goodman_cc}{Point estimate, Goodman method Confidence intervals with continuity correction}
\item{lwr_ci_goodman_cc}{Lower bound of Goodman confidence interval}
\item{upr_ci_goodman_cc}{Upper bound of Goodman confidence interval}
\item{est_sisonglaz}{Point estimate, Sison-Glaz method Confidence intervals}
\item{lwr_ci_sisonglaz}{Lower bound of Sison-Glaz confidence interval}
\item{upr_ci_sisonglaz}{Upper bound of Sison-Glaz confidence interval}
\item{est_qhurst_acswr}{Point estimate, Queensbury-Hurst method Confidence intervals via ACSWR r package}
\item{lwr_ci_qhurst_acswr}{Lower bound of Queensbury-Hurst confidence interval}
\item{upr_ci_qhurst_acswr}{Upper bound of Queensbury-Hurst confidence interval}
\item{est_qhurst_coinmind}{Point estimate, Queensbury-Hurst method Confidence intervals via CoinMinD r package}
\item{lwr_ci_qhurst_coinmind}{Lower bound of Queensbury-Hurst confidence interval}
\item{upr_ci_qhurst_coinmind}{Upper bound of Queensbury-Hurst confidence interval}
\item{lwr_ci_qhurst_adj_coinmind}{Lower bound of Queensbury-Hurst confidence interval adjusted}
\item{upr_ci_qhurst_adj_coinmind}{Upper bound of Queensbury-Hurst confidence interval adjusted}
}
}
\source{
\url{https://magosil86.github.io/bumblebee/}
}
\usage{
estimated_hiv_transmission_flows
}
\description{
Estimated HIV transmissions within and betweeen intervention and control communities
in the BCPP/Ya Tsie trial population adjusted for variability in sampling.
}
\references{
Magosi LE, et al., Deep-sequence phylogenetics to quantify patterns of
HIV transmission in the context of a universal testing and treatment
trial – BCPP/ Ya Tsie trial. To submit for publication, 2021.
}
\keyword{datasets}
