% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_bunching.R
\name{fit_bunching}
\alias{fit_bunching}
\title{Fit Bunching}
\usage{
fit_bunching(thedata, themodelformula, binwidth, notch = FALSE, zD_bin = NA)
}
\arguments{
\item{thedata}{(binned) data that includes all variables necessary for fitting the model.}

\item{themodelformula}{formula to fit.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{zD_bin}{the bin marking the upper end of the dominated region (notch case).}
}
\value{
\code{fit_bunching} returns a list of the following results:
\item{coefficients}{The coefficients from the fitted model.}
\item{residuals}{The residuals from the fitted model.}
\item{cf_density}{The estimated counterfactual density.}
\item{bunchers_excess}{The estimate of the excess mass (not normalized).}
\item{cf_bunchers}{The counterfactual estimate of counts in the bunching region.}
\item{b_estimate}{The estimate of the normalized excess mass.}
\item{bins_bunchers}{The number of bins in the bunching region.}
\item{model_formula}{The model formula used for fitting.}
\item{B_zl_zstar}{The count of bunchers in the bunching region below and up to zstar.}
\item{B_zstar_zu}{The count of bunchers in the bunching region above zstar.}
\item{alpha}{The estimated fraction of bunchers in the dominated region (only in notch case.)}
\item{zD_bin}{The value of the bin which zD falls in.}
}
\description{
Fit bunching model to (binned) data and estimate excess mass.
}
\examples{
data(bunching_data)
binned_data <- bin_data(z_vector = bunching_data$kink, zstar = 10000,
                        binwidth = 50, bins_l = 20, bins_r = 20)
prepped_data <- prep_data_for_fit(binned_data, zstar = 10000, binwidth = 50,
                                  bins_l = 20, bins_r = 20, poly = 4)
fitted <- fit_bunching(thedata = prepped_data$data_binned,
                       themodelformula = prepped_data$model_formula,
                       binwidth = 50)
# extract coefficients
fitted$coefficients
}
\seealso{
\code{\link{bunchit}}, \code{\link{prep_data_for_fit}}
}
