% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_longPutButterfly.R
\name{longPutButterfly}
\alias{longPutButterfly}
\title{Calculates per share Profit and Loss (PnL) at expiration for Long Put Butterfly Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
longPutButterfly(
  ST,
  X,
  X1L,
  X3H,
  P,
  P1L,
  P3H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price for two ATM sold puts.}

\item{X1L}{Lower Strike Price or eXercise price for one OTM long put.}

\item{X3H}{Higher Strike Price or eXercise price for one ITM long put.}

\item{P}{put Premium or put Price received for the two ATM sold puts.}

\item{P1L}{put Premium or put Price paid for the first OTM long put.}

\item{P3H}{put Premium or put Price paid for the one ITM long put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss column of the data frame}

\item{myData}{Data frame}

\item{myTibble}{Tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This consists of a long position in an OTM (out of the money) put option with a strike price $X1L, short positions in two ATM ( at the money) put options with a strike price $X, and a long position in an ITM (in the money) put option with a strike price $X3H. The strikes are equidistant: $X3H minus $X equals to $X minus $X1L (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Long put Butterfly Option Strategy and draw its graph in the Plots tab.
}
\examples{
longPutButterfly(100,100,80,120,6,1,20,hl=0.55,hu=1.45)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865 \cr
R Graphics Cookbook. (n.d.). Coloring Negative and Positive Bars Differently. https://r-graphics.org/recipe-bar-graph-color-neg \cr
Gross C, Ottolinger P (2016).\emph{ggThemeAssist: Add-in to Customize 'ggplot2' Themes}. R package version 0.1.5, <URL: https://CRAN.R-project.org/package=ggThemeAssist>.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
