% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_normal_covar_tvp.R
\name{post_normal_covar_tvp}
\alias{post_normal_covar_tvp}
\title{Posterior Simulation of Error Covariance Coefficients}
\usage{
post_normal_covar_tvp(y, u_omega_i, v_sigma_i, psi_init)
}
\arguments{
\item{y}{a \eqn{K \times T} matrix of data with \eqn{K} as the number of
endogenous variables and \eqn{T} the number of observations.}

\item{u_omega_i}{matrix of error variances of the measurement equation.
Either a \eqn{K \times K} matrix for constant variances or
a \eqn{KT \times KT} matrix for time varying variances.}

\item{v_sigma_i}{matrix of error variances of the state equation.
Either an \eqn{M \times M} matrix for constant variances or
an \eqn{MT \times MT} matrix for time varying variances, where \eqn{M} is the
number of estimated variables.}

\item{psi_init}{a vector of inital values of the state equation.}
}
\value{
A matrix.
}
\description{
Produces posterior draws of time varying error covariance coefficients.
}
\details{
For the multivariate model \eqn{A_{0,t} y_t = u_t} with \eqn{u_t \sim N(0, \Omega_t)}
the function produces a draw of the lower triangular part of \eqn{A_{0,t}} similar as in
Primiceri (2005), i.e., using \deqn{y_t = Z_t \psi_t + u_t,}
where 
\deqn{Z_{t} = \begin{bmatrix} 0 & \dotsm & \dotsm & 0 \\ -y_{1, t} & 0 & \dotsm & 0 \\ 0 & -y_{[1,2], t} & \ddots & \vdots \\ \vdots & \ddots & \ddots & 0 \\ 0 & \dotsm & 0 & -y_{[1,...,K-1], t} \end{bmatrix}}
and \eqn{y_{[1,...,K-1], t}} denotes the first to \eqn{(K-1)}th elements of the vector \eqn{y_t}.

The algorithm of Chan and Jeliazkov (2009) is used to obtain time varying coefficients.
}
\examples{
# Load example data
data("e1")
y <- log(t(e1))

# Generate artificial draws of other matrices
u_omega_i <- diag(1, 3)
v_sigma_i <- diag(1000, 3)
psi_init <- matrix(0, 3)

# Obtain posterior draw
post_normal_covar_tvp(y, u_omega_i, v_sigma_i, psi_init)

}
\references{
Chan, J., & Jeliazkov, I. (2009). Efficient simulation and integrated likelihood estimation in state space
models. \emph{International Journal of Mathematical Modelling and Numerical Optimisation, 1}(1/2), 101–120.
\doi{10.1504/IJMMNO.2009.030090}

Primiceri, G. E. (2005). Time varying structural vector autoregressions and monetary policy.
\emph{The Review of Economic Studies, 72}(3), 821--852. \doi{10.1111/j.1467-937X.2005.00353.x}
}
