% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sci.R
\name{plot_sci}
\alias{plot_sci}
\title{Lorenz Curve for the Situational Clustering Index}
\usage{
plot_sci(cacc_matrix)
}
\arguments{
\item{cacc_matrix}{A tibble. The output of the \code{cacc} function.}
}
\value{
Returns a ggplot object.
}
\description{
Plots a Lorenz Curve for the Situational Clustering Index (SCI) to visualize the magnitude of the clustering of observations among dominant profiles in a \code{cacc_matrix}.
}
\examples{
plot_sci(cacc_matrix = cacc(onharassment, ivs = sex:privacy, dv = rep_victim))
}
\references{
Hart, T. C. (2019). Identifying Situational Clustering and Quantifying Its Magnitude in Dominant Case Configurations: New Methods for Conjunctive Analysis. \emph{Crime & Delinquency, 66}(1), 143-159.
}
