#' Open cancer RADAR output file dictionary
#'
#' Calling this function will open the dictionary describing sheets and variables stored in the cancer
#' summary file (output file generated by \code{\link{create_canradar_summary_file}} function). It
#' could be useful for the cancer registries to check what kind of data they will be sharing.
#' Note that a temporary copy of the dictionary is created on your hard drive to prevent from
#' unwanted file modification.
#'
#' @return the path to a temporary file where cancer RADAR dictionary is stored
#' @export
#'
#' @examples
#' \dontrun{
#'    open_canradar_dictionary()
#' }
open_canradar_dictionary <-
  function() {
    dict.file <- system.file(
      "extdata",
      "dictionary_cancerradarr_output_file.xlsx",
      package = "cancerradarr"
    )
    dict.dir <- tempdir()
    dict.file.tmp <- file.path(dict.dir, basename(dict.file))
    file.copy(dict.file, dict.file.tmp)
    openXL(dict.file.tmp)
    dict.file.tmp
  }
