% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motivation_and_confidence.R
\name{get_predilection_score}
\alias{get_predilection_score}
\title{Compute a predilection score.}
\usage{
get_predilection_score(csappa1 = NA, csappa3 = NA, csappa5 = NA)
}
\arguments{
\item{csappa1}{A numeric (integer) vector representing a response to CSAPPA item 1 (valid values are integers between 1 and 4).}

\item{csappa3}{A numeric (integer) vector representing a response to CSAPPA item 3 (valid values are integers between 1 and 4).}

\item{csappa5}{A numeric (integer) vector representing a response to CSAPPA item 5 (valid values are integers between 1 and 4).}
}
\value{
Returns a numeric vector with values between 1.8 and 7.5 (if valid) or NA (if not valid).
}
\description{
This function computes a predilection score (\code{predilection_score}) for responses to items 1, 3 and 5 of the CSAPPA (Children's Self-Perceptions of
Adequacy in and Predilection for Physical Activity; Hay, 1992) Questionnaire as they appear in \href{https://www.capl-eclp.ca/wp-content/uploads/2018/02/CAPL-2-questionnaire.pdf}{the CAPL-2 Questionnaire}. This score is used to compute
the motivation and confidence domain score (\code{mc_score}).
}
\details{
Valid values (integers between 1 and 4) represent the following responses:
\itemize{
\item 1 = REALLY TRUE for me for "some kids" statements
\item 2 = SORT OF TRUE for me for "some kids" statements
\item 3 = REALLY TRUE for me for "other kids" statements
\item 4 = SORT OF TRUE for me for "other kids" statements
}

Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.
}
\examples{
get_predilection_score(
  csappa1 = c(1:3, 0),
  csappa3 = c(4, 2, 1, "3"),
  csappa5 = c(4, 4, 2, 2)
)

# [1] 4.2 4.2 4.3  NA

}
