% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/border-color.R
\name{border_color}
\alias{border_color}
\alias{border_subtle}
\title{Change border color}
\usage{
border_color(x, color)

border_subtle(x, color)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{color}{A character string specifying a color. One of,
\itemize{
\item \code{"primary"}
\item \code{"secondary"}
\item \code{"success"}
\item \code{"danger"}
\item \code{"warning"}
\item \code{"info"}
\item \code{"light"}
\item \code{"dark"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{border_color()} and \code{border_subtle()} functions adjust the border
color of a tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    border_color(theme_primary())
)

div(
  .style \%>\%
    background_subtle(theme_danger()) \%>\%
    border_subtle(theme_danger()) \%>\%
    text_emphasis(theme_danger()),
  "Danger theme with some emphasis"
)


div(
  .style \%>\%
    background_subtle(theme_light()) \%>\%
    text_emphasis(theme_light()) \%>\%
    border_subtle(theme_light())
)

}
\seealso{
Other border utilities: 
\code{\link{border_width}()}
}
\concept{border utilities}
