% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtbeta}
\alias{dtbeta}
\alias{ptbeta}
\alias{qtbeta}
\alias{rtbeta}
\title{Density function of Truncated Beta Distribution}
\usage{
dtbeta(x, shape1, shape2, ncp = 0, min = 0, max = 1)

ptbeta(q, shape1, shape2, ncp = 0, min = 0, max = 1)

qtbeta(p, shape1, shape2, ncp = 0, min = 0, max = 1)

rtbeta(n, shape1, shape2, ncp = 0, min = 0, max = 1)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{shape1}{distribution parameter}

\item{shape2}{distribution parameter}

\item{ncp}{non-centrality parameter (Default: 0)}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Beta Distribution

Cumulative probability function of Truncated Beta Distribution

Quantile function of Truncated Beta Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Beta Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtbeta(0.6,1,2)
ptbeta(0.5,1,2)
qtbeta(0.5,1,2)
rtbeta(100,1,2)
}
