% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{ultiDevFac}
\alias{ultiDevFac}
\title{Calculate ultimate development factor based on current development year, a mean development factor schedule and its volatility. It is used to simulate the ultimate loss for open claims.}
\usage{
ultiDevFac(Years, meanDevFac, sdDevFac = rep(0, length(meanDevFac)),
  distType = "normal")
}
\arguments{
\item{Years}{Include two columns: Current development year and Settlement Year}

\item{meanDevFac}{A vector that contains the expected development factor schedule for Normal distribution. It is mu for Lognormal distribution and shape for Gamma distribution.}

\item{sdDevFac}{A vector that contains the standard deviation of expected development factor schedule for Normal distribution. It is sigma for Lognormal distribution and scale for Gamma distribution.}

\item{distType}{distribution type for development factor. It can be "normal", "lognormal" or "gamma".}
}
\description{
Calculate ultimate development factor based on current development year, a mean development factor schedule and its volatility. It is used to simulate the ultimate loss for open claims.
}
\examples{
meanfac<-c(1.1,1.08,1.05,1.03,1.01,1)
volfac<-rep(0.02,6)
years<-matrix(c(1:6),3,2)
ultiDevFac(years,meanfac,volfac)
}
