% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scree.R
\name{scree}
\alias{scree}
\title{Pre-processing to generate scagnostic measures}
\usage{
scree(x, y, binner = NULL, ...)
}
\arguments{
\item{x, y}{numeric vectors}

\item{binner}{an optional function that bins the x and y vectors prior
to triangulation}

\item{...}{other args}
}
\value{
An object of class "scree" that consists of three elements:
\itemize{
\item \code{del}: the Delauney-Voronoi tesselation from \code{\link[alphahull:delvor]{alphahull::delvor()}}
\item \code{weights}: the lengths of each edge in the Delauney triangulation
\item \code{alpha}: the radius or \code{alpha} value that will be used to generate the
alphahull
}
}
\description{
Pre-processing to generate scagnostic measures
}
\examples{

x <- runif(100)
y <- runif(100)
scree(x,y)

}
